//
//  FJDItemsInFolderWindowController.h
//  FJDItemsInFolderWindow
//
//  Created by FUJIDANA on 06/08/17.
//  Copyright 2006 FUJIDANA. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "FJDPersistentWindowController.h"


extern NSString *FJDItemsInFolderToolbarNewIdentifier;
extern NSString *FJDItemsInFolderToolbarNewItemIdentifier;
extern NSString *FJDItemsInFolderToolbarNewFolderIdentifier;
extern NSString *FJDItemsInFolderToolbarDeleteIdentifier;
extern NSString *FJDItemsInFolderToolbarDeleteItemIdentifier;
extern NSString *FJDItemsInFolderToolbarDeleteFolderIdentifier;
extern NSString *FJDItemsInFolderToolbarPreviousItemIdentifier;
extern NSString *FJDItemsInFolderToolbarNextItemIdentifier;
extern NSString *FJDItemsInFolderToolbarPreviousFolderIdentifier;
extern NSString *FJDItemsInFolderToolbarNextFolderIdentifier;
extern NSString *FJDItemsInFolderToolbarDeselectSortIdentifier;
extern NSString *FJDItemsInFolderToolbarSearchItemIdentifier;

extern NSString* FJDObjectIDsPboardType;


@class FJDSortedArrayController;


@interface FJDItemsInFolderWindowController : FJDPersistentWindowController
{
	IBOutlet NSSearchField *searchField;
	
	IBOutlet NSTableView *itemsTableView;
	IBOutlet NSTableView *foldersTableView;
	
	IBOutlet FJDSortedArrayController *itemsController;
	IBOutlet FJDSortedArrayController *foldersController;
}

- (NSString *)localizedItemName;
- (NSString *)localizedPluralItemName;
- (NSString *)localizedFolderName;
- (NSString *)localizedPluralFolderName;

#pragma mark Other public methods
- (BOOL)setSelectedObject:(NSManagedObject *)object;

@end


#pragma mark -


@interface FJDItemsInFolderWindowController (UserInterface)

#pragma mark Methods to set up toolbar
- (void)setupToolbarWithIdentifier:(NSString *)identifier;

#pragma mark Methods delegated by NSToolbar
- (NSToolbarItem *)toolbar:(NSToolbar *)toolbar itemForItemIdentifier:(NSString *)itemIdentifier willBeInsertedIntoToolbar:(BOOL)flag;
- (NSArray *)toolbarDefaultItemIdentifiers:(NSToolbar *)toolbar;
- (NSArray *)toolbarAllowedItemIdentifiers:(NSToolbar *)toolbar;
- (void)toolbarDidRemoveItem:(NSNotification *)notification;

#pragma mark NSToolbarItemValidation informal protocol
- (BOOL)validateToolbarItem:(NSToolbarItem *)theItem;

#pragma mark NSMenuValidation informal protocol
- (BOOL)validateMenuItem:(id <NSMenuItem>)menuItem;

#pragma mark Action methods
- (IBAction)insert:(id)sender;
- (IBAction)insertItem:(id)sender;
- (IBAction)insertFolder:(id)sender;
- (IBAction)delete:(id)sender;
- (IBAction)deleteItem:(id)sender;
- (IBAction)deleteFolder:(id)sender;
- (IBAction)selectPreviousItem:(id)sender;
- (IBAction)selectNextItem:(id)sender;
- (IBAction)selectPreviousFolder:(id)sender;
- (IBAction)selectNextFolder:(id)sender;
- (IBAction)deselectSort:(id)sender;
- (IBAction)find:(id)sender;

@end


#pragma mark -


@interface FJDItemsInFolderWindowController (DragAndDrop)

- (void)setupForDragAndDropOperation;

- (NSArray *)readablePasteboardTypes;

//#pragma mark Methods implementing NSTableDataSource informal protocol
//// --- subclass must invoke this method when override. ---
//- (int)numberOfRowsInTableView:(NSTableView *)tableView;
//- (id)tableView:(NSTableView *)tableView objectValueForTableColumn:(NSTableColumn *)tableColumn row:(int)rowIndex;
//- (BOOL)tableView:(NSTableView *)tableView writeRowsWithIndexes:(NSIndexSet *)rowIndexes toPasteboard:(NSPasteboard *)pboard;
//- (NSDragOperation)tableView:(NSTableView *)tableView validateDrop:(id <NSDraggingInfo>)info proposedRow:(int)row proposedDropOperation:(NSTableViewDropOperation)operation;
//- (BOOL)tableView:(NSTableView *)tableView acceptDrop:(id <NSDraggingInfo>)info row:(int)row dropOperation:(NSTableViewDropOperation)operation;

@end
